require( "quest/m1_beautydrawer/convout.lua" );
combine_speech_tables();

currentDepth = 0;
moving_actor = nil;
item_upscale = 1.15;

function found_dye(actor)
	scene.FLO:SetMode(MODE.CUTSCENE);
	actor:SetDepthValue(currentDepth);
	help_panel_say_raw(scene:grabstring("quip_pickup_remover"));
	--BAG_INV:AddInventory(inv_desc_dyeremover);
	clear_item_meshes();
	scene:Spawn(big_dye_spec);
	actor:Expire();
end

-- drawer items
local items = 
{

	{ image = "drawer_item02",			depth = 3,		target = false, x = 250, y = 5 },
	{ image = "drawer_item02",			depth = 3,		target = false, x = 250, y = 105 },
	{ image = "drawer_item03",			depth = 12,		target = false, x = 76, y = 44 },
	{ image = "drawer_item04",			depth = 2,		target = false, x = 265, y = 15 },
	{ image = "drawer_item04",			depth = 10,		target = false, x = 525, y = 225 },
	{ image = "drawer_item04b",			depth = 2,		target = false, x = 500, y = 90 },
	{ image = "drawer_item05",			depth = 10,		target = false, x = 190, y = 98 },
	{ image = "drawer_item06",			depth = 9,		target = false, x = 275, y = 240 },
	{ image = "drawer_item07",			depth = 4,		target = false, x = 75, y = 8 },
	{ image = "drawer_item08",			depth = 14,		target = false, x = 70, y = 250 },
	{ image = "drawer_item09",			depth = 11, 		target = false, x = 510, y = 57 },
	{ image = "drawer_item10",			depth = 8,		target = false, x = 660, y = 140 },
	{ image = "drawer_item11",			depth = 5,		target = false, x = 450, y = 175 },
	{ image = "drawer_item11",			depth = 5,		target = false, x = 200, y = 100 },
	{ image = "drawer_item12",			depth = 13,		target = false, x = 350, y = 80 },
	{ image = "drawer_item12",			depth = 2,		target = false, x = 80, y = 20 },
	{ image = "drawer_item13",			depth = 7,		target = false, x = 275, y = 50 },
	{ image = "drawer_item13",			depth = 13,		target = false, x = 570, y = 200 },
	{ image = "drawer_item14",			depth = 2,		target = false, x = 150, y = 8 },

	{ image = "drawer_item01",	depth = 1,	target = quest_complete("check_with_walter"), x = 260, y = 60, foundProc = found_dye},                                                          
};

active_items = {};

function get_drawer_item_spec(_name, _image, _depth, _target, _x, _y, _foundProc)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		
		command = function(actor)
			actor:SetDepthValue(_depth);
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor_open_hand");
			actor.moving = false;
			actor.foundProc = _foundProc;
			actor.halo = _image;
			
			if _target then
				actor.on_click = function(flo, drawer_item)
					game:Set("found_target_drawer_item", 1);
					drawer_item:StartProc(actor.foundProc);
					return RESPONSE.IGNORE;
				end;
			else
				actor.on_click = function(flo, drawer_item)
					--actor.hotspot = { x = 50, y = 50 };
					if game:Get("found_target_drawer_item") == 0 then
						if actor.moving == false then
							local clickedAt = scene:GetClickedAtScreen();
							local actorPos = actor:GetPosition();
							actor.moving = true;
							actor.movingx = actorPos.x - clickedAt.x;
							actor.movingy = actorPos.y - clickedAt.y ;
							actor:SetDepthValue(currentDepth);
							currentDepth = currentDepth + 1;
							actor:StartProc(move_item);
							moving_actor = actor;
							actor:SetPointAtCursor("cursor_closed_hand");
							scene.GAME_CONTROLLER:StartProc(moving_item);
							sfx:PlaySFX("audio/sfx/pickup_item.ogg");
							actor:LoadZone("over_actor");
						end
					end
					return RESPONSE.IGNORE;
				end;
				
				actor.point_at_fn = function(flo, enter)
					local scalemod = 1;
					local upscale = item_upscale;
					
					--if _data.scale then
					--	scalemod = _data.scale;
					--	upscale = upscale * scalemod;
					--end
					
					if (moving_actor == nil or actor == moving_actor) and game:Get("found_target_purse_item") == 0 then
						if enter then
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * scalemod;
							image_size1.y = image_size1.y * scalemod;
							--image_size1.x = image_size1.x * activity_data.scale;
							--image_size1.y = image_size1.y * activity_data.scale;
							actor:SetScale(upscale);
							--sfx:PlaySFX("audio/sfx/sfx_typing_03.ogg");
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * (upscale);
							image_size2.y = image_size2.y * (upscale);
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
						else
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * (upscale);
							image_size1.y = image_size1.y * (upscale);
							actor:SetScale(scalemod);
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * scalemod;
							image_size2.y = image_size2.y * scalemod;
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
							--sfx:PlaySFX("audio/sfx/sfx_typing_02.ogg");
						end
					end
				end;
			end
		end;
	}
end

function spawn_drawer_items(actor)
	for i,v in pairs(items) do
		local drawer_item_spec = get_drawer_item_spec(tostring(i), v.image, v.depth, v.target, v.x, v.y, v.foundProc);
		if currentDepth <= v.depth then
			currentDepth = v.depth + 1;
		end
		--table.insert(scene_spec.actorlist, drawer_item_spec);
		local drawer_item = scene:Spawn(drawer_item_spec);
		if not v.target then
			table.insert(active_items, drawer_item);
		end
	end
end

function clear_item_meshes()
	for i,v in pairs(active_items) do
		if v then
			v:DumpZone();
		end
	end
end

game_controller_spec = 
{
	name = "GAME_CONTROLLER";
}

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function move_item(actor)
	while actor.moving do
		local cursorPos = scene:GetCursorPos();
		local newPoint = { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };
		newPoint.x = math.min(math.max(0, newPoint.x), 800-actor:GetImageSize().x);
		newPoint.y = math.min(math.max(0, newPoint.y), 500-actor:GetImageSize().y);
		actor:JumpToPoint(newPoint);
		coroutine.yield(RESUME.NOW);
	end
end

-- running as GAME_CONTROLLER proc whilst actor is moving
function moving_item(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.NOW);
	
	-- if we didn't click on another clothing item, put us back
	stop_moving();
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function stop_moving()
	-- if we didn't click on another clothing item, put us back
	if moving_actor ~= nil then
		moving_actor:LoadZone(moving_actor.halo);
		moving_actor.moving = false;
		moving_actor:SetPointAtCursor("cursor_open_hand");
		moving_actor = nil;
		sfx:PlaySFX("audio/sfx/drop_item.ogg");
	end;
end

big_dye_spec = 
{
	name = "BIG_DYE";
	gfx = { image = "popup/pop_inv_dyeremover" };
	
	command = function(actor)
		actor:SetDepthValue(currentDepth);
		
		local flashFrequency = 10;
		local flashTime = 90;
		local imageSize = actor:GetImageSize();
		local popupLocation = { x = 400 - (imageSize.x / 2), y = 300 - (imageSize.y / 2) };
		local imageStr = "popup/pop_inv_dyeremover";
		local imageHaloStr = "popup/pop_inv_dyeremover_halo";
		
		actor:JumpToPoint(popupLocation);
		sfx:PlaySFX("audio/sfx/get_item.ogg");
		
		local timer = 0;
		local halo = true;
		
		-- flash
		while timer < flashTime do
			if halo then
				actor:LoadImage(imageStr);
				halo = false;
			else
				actor:LoadImage(imageHaloStr);
				halo = true;
			end
			
			timer = timer + flashFrequency;
			delay(flashFrequency);
		end
		game:Set("got_dye_remover", 1);
		coroutine.yield(RESUME.ON_CLICK);
		
		scene.FLO:StartProc(go_back);
	end;
};

function go_back(flo)
	kill_help_panel();
	scene:ReturnFromScene();
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		-- scene:SetRoomScale(300, 550, 0.2, 0.4);	--topline, bottomline, topscale, bottomscale
		sfx:SetMusic("audio/music/beautysalonmusic.ogg", true);
		scene:SetCameraFollowActor(nil);
		scene:SetTextBoundsXY(20, 20);
		game:ClearInvUsage();
		
		
		if IsCheatMode() then
			--testing
		end
		
		fade_scene_up(true, true);
		spawn_drawer_items();
		lower_hud();
		spawn_help_panel();
		
		game:Set("found_target_drawer_item", 0);
		
		if quest_complete("check_with_walter") then
			help_panel_say_raw(scene:grabstring("quip_find_remover"));
		else
			help_panel_say_raw(scene:grabstring("quip_find_remover_alt"));
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
		"pieces2",
	};
	
	bg_image = 
	{
		{ "background", 0 },
	};
	
	ground = "background";
	
	actorlist = 
	{ 
		game_controller_spec,
		flo_spec,
		
		scene_setup,
	};
};
